<?php

namespace App\Http\Resources;

use App\Traits\TemplateElementSyncProviders;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use JsonSerializable;
use Mtc\ContentManager\Contracts\ContentElement;
use Mtc\ContentManager\Contracts\GlobalContent;
use Mtc\ContentManager\Contracts\Menu;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Template;
use Mtc\ContentManager\Contracts\ModelWithContent;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\VehicleOffer;

class ElementUsageListResource extends JsonResource
{
    use TemplateElementSyncProviders;

    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */

    public $resource;

    private ContentElement $element;

    public function setElement(ContentElement $element): self
    {
        $this->element = $element;
        return $this;
    }

    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator) {
            $this->resource
                ->through(fn(ModelWithContent $entry) => $this->mapRecord($entry));
        } else {
            $this->resource = $this->resource
                ->map(fn(ModelWithContent $entry) => $this->mapRecord($entry))
                ->filter()
                ->values();
        }
        return parent::toArray($request);
    }

    /**
     * Map template record
     *
     * @param Model $page
     * @return array
     */
    protected function mapRecord(ModelWithContent $entry)
    {
        $repository = $this->getRepository($entry);
        return match (true) {
            $entry instanceof Page => [
                'id' => $entry->id,
                'title' => $entry->title,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/content/edit/' . $entry->id,
                'in_sync' => $repository->isContentElementInSync($entry, $this->element),
                'type' => 'page',

            ],
            $entry instanceof VehicleOffer => [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/offers/edit/' . $entry->id,
                'in_sync' => $repository->isContentElementInSync($entry, $this->element),
                'type' => 'offer',
            ],
            $entry instanceof NewCar => [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/new-vehicles/edit/' . $entry->id,
                'in_sync' => $repository->isContentElementInSync($entry, $this->element),
                'type' => 'new car',
            ],
            $entry instanceof GlobalContent => [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/global/edit/' . $entry->id,
                'type' => 'global content',
            ],
            $entry instanceof Menu => [
                'id' => $entry->id,
                'title' => $entry->title,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/menus/edit/' . $entry->id,
                'type' => 'navigation menu',
            ],
            $entry instanceof Template => [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/templates/edit/' . $entry->id,
                'in_sync' => $repository->isContentElementInSync($entry, $this->element),
                'type' => 'template',
            ],
            default => [],
        };
    }
}
