<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Jobs\CarGurusExportJob;
use App\Modules\SalesChannels\CarGuru;
use Database\Seeders\Tenant\CarGuruExportSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Tests\TestCase;

class CarGuruExportTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('car-guru-export');
        $this->seed(CarGuruExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-gurus-file-name', 'foo.csv');

        $this->dispatch(new CarGurusExportJob());

        Storage::disk('car-guru-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-gurus')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Storage::fake('car-guru-export');
        $this->seed(CarGuruExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-gurus-file-name', 'foo.csv');
        Settings::update('sales-channels-car-gurus-enabled', true);

        app(CarGuru::class)->runScheduledExport();

        Storage::disk('car-guru-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-gurus')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
