<?php

namespace Tests\Feature;

use App\Console\Commands\GenerateReportingStats;
use App\Reporting\StatsModels\EnquiriesPerDay;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Config;
use Mtc\MercuryDataModels\ReportingStat;
use Tests\TenantTestCase;
use Tests\TestCase;

class GenerateReportingStatsTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testGenerateStats()
    {
        Config::set('stats-types', [
            'enquiries-per-day' => EnquiriesPerDay::class,
        ]);

        $response = $this->artisan(GenerateReportingStats::class);
        $response->run();
        $response->assertExitCode(0);

        $this->assertTrue(ReportingStat::query()->where('date', Carbon::yesterday())->exists());
    }
}
