<?php

namespace App;

use App\Http\Resources\OfferTileListResource;
use App\Http\Resources\VehicleListResource;
use App\Services\GraphService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\Booking;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\User;
use Mtc\MercuryDataModels\UserDashboardWidget;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;
use Mtc\VehicleReservations\Reservation;

class AdminDashboardRepository
{
    public function enquiries(int $days = 1): int
    {
        $total = (object)['value' => 0];
        tenancy()->runForMultiple(null, fn() => $total->value += Enquiry::query()->where('ingested_at', '>=', Carbon::now()->subDays($days - 1))->count());
        return $total->value;
    }

    public function reservations(int $days = 1): int
    {
        $total = (object)['value' => 0];
        tenancy()->runForMultiple(null, fn() => $total->value += Reservation::query()->where('ingested_at', '>=', Carbon::now()->subDays($days - 1))->count());
        return $total->value;
    }

    public function serviceBookings(int $days = 1)
    {
        $total = (object)['value' => 0];
        tenancy()->runForMultiple(null, fn() => $total->value += Booking::query()->where('ingested_at', '>=', Carbon::now()->subDays($days - 1))->count());
        return $total->value;
    }
}
