<?php

namespace App\Console\Commands;

use App\Events\VehicleRequiredAttributeCheck;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Event;
use Mtc\MercuryDataModels\VehicleAttribute;

class CheckForRequiredVehicleAttributes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'vehicles:check-for-required-attributes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Checks if any integration requires an attribute that does not exist and adds it';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        collect(Event::dispatch(new VehicleRequiredAttributeCheck()))
            ->filter()
            ->dump()
            ->each(fn(array $attribute) => VehicleAttribute::query()->updateOrCreate([
                'slug' => $attribute['slug']
            ], $attribute));
    }
}
