<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class VehicleSearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [];
    }

    public function getSelections(): array
    {
        if (empty($this->input('selections'))) {
            return [];
        }

        return collect($this->input('selections'))
            ->filter(fn($value) => isset($value['id']))
            ->map(fn($value) => [
                'type' => $value['type'],
                'id' => $value['id'] === 'null' ? null : $value['id'],
            ])
            ->groupBy('type')
            ->map(fn($grouped, $type) => [
                'type' => $type,
                'values' => $grouped->pluck('id')->toArray()
            ])
            ->toArray();
    }
}
