<?php

namespace App;

use App\Facades\Settings;
use App\Jobs\ImportAutosOnShowFilesJob;
use App\Services\AutosOnShow;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\Vehicle;

class ImageSyncServiceHelper
{
    use DispatchesJobs;

    /**
     * Trigger image sync process for enabled provider
     *
     * @param Vehicle $vehicle
     * @return void
     */
    public function triggerSync(Vehicle $vehicle): void
    {
        match ($this->enabledService()) {
            'autos-on-show' => $this->dispatch(new ImportAutosOnShowFilesJob($vehicle, app(AutosOnShow::class))),
            default => null,
        };
    }

    /**
     * Get the enabled image sync service
     *
     * @return string
     */
    public function enabledService(): string|null
    {
        if (TierHelper::isAllowed(tenant()->tier, Tier::STANDARD->value) === false) {
            return null;
        }

        return collect(config('services.image-sync', []))
            ->filter(fn ($service) => Settings::get($service['enabled_config_key']))
            ->keys()
            ->first();
    }
}
