<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FixBcaCapSettingType extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(function ($setting) {
                $setting['value'] = Settings::get($setting['config_key']);
                return Settings::make($setting, true);
            });
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'BCA',
                'name' => 'Api Secret',
                'config_key' => 'valuation-bca-api_secret',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Valuation',
                'group' => 'CAP',
                'name' => 'Password',
                'config_key' => 'valuation-cap-password',
                'type' => 'secret',
                'min_tier' => 'pro',
                'value' => '',
            ],
        ];
    }
}
