<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class OpenAIConditionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Use vehicle technical data to generate descriptions',
                'config_key' => 'open-ai-generate-description-use-tech-data',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => false,
                'description' => '',
                'order' => 10,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'AI',
                'group' => 'Open AI',
                'name' => 'Use vehicle standard equipment to generate descriptions',
                'config_key' => 'open-ai-generate-description-use-equipment',
                'type' => 'boolean',
                'min_tier' => 'pro',
                'value' => true,
                'description' => '',
                'order' => 11,
            ],
        ];
    }
}
