<?php

namespace Tests\Feature;

use App\Console\Commands\UpdateCurrencies;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Http;
use Mtc\MercuryDataModels\Currency;
use Tests\TestCase;

class CurrencyUpdaterTest extends TestCase
{
    use RefreshDatabase;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testUpdateCurrencies()
    {
        Http::fake([
            config('services.currency.endpoint') => Http::response($this->response()),
            "*" => Http::response([], 400),
        ]);
        $response = $this->artisan(UpdateCurrencies::class);
        $response->run();
        $response->assertExitCode(0);

        $this->assertTrue(Currency::query()->where('code', 'USD')->where('ratio', 1.09)->exists());
        $this->assertTrue(Currency::query()->where('code', 'JPY')->where('ratio', 137.01)->exists());
        $this->assertEquals(33, Currency::query()->count());
    }

    public function response()
    {
        return <<<EOS
<?xml version="1.0" encoding="UTF-8"?>
<gesmes:Envelope xmlns:gesmes="http://www.gesmes.org/xml/2002-08-01" xmlns="http://www.ecb.int/vocabulary/2002-08-01/eurofxref">
    <gesmes:subject>Reference rates</gesmes:subject>
    <gesmes:Sender>
        <gesmes:name>European Central Bank</gesmes:name>
    </gesmes:Sender>
    <Cube>
        <Cube time='2022-04-11'>
            <Cube currency='USD' rate='1.0900'/>
            <Cube currency='JPY' rate='137.01'/>
            <Cube currency='BGN' rate='1.9558'/>
            <Cube currency='CZK' rate='24.429'/>
            <Cube currency='DKK' rate='7.4375'/>
            <Cube currency='GBP' rate='0.83693'/>
            <Cube currency='HUF' rate='378.27'/>
            <Cube currency='PLN' rate='4.6456'/>
            <Cube currency='RON' rate='4.9397'/>
            <Cube currency='SEK' rate='10.3128'/>
            <Cube currency='CHF' rate='1.0180'/>
            <Cube currency='ISK' rate='140.00'/>
            <Cube currency='NOK' rate='9.5478'/>
            <Cube currency='HRK' rate='7.5519'/>
            <Cube currency='TRY' rate='16.0485'/>
            <Cube currency='AUD' rate='1.4654'/>
            <Cube currency='BRL' rate='5.1550'/>
            <Cube currency='CAD' rate='1.3738'/>
            <Cube currency='CNY' rate='6.9405'/>
            <Cube currency='HKD' rate='8.5440'/>
            <Cube currency='IDR' rate='15658.28'/>
            <Cube currency='ILS' rate='3.5010'/>
            <Cube currency='INR' rate='82.7085'/>
            <Cube currency='KRW' rate='1345.23'/>
            <Cube currency='MXN' rate='21.8653'/>
            <Cube currency='MYR' rate='4.6112'/>
            <Cube currency='NZD' rate='1.5938'/>
            <Cube currency='PHP' rate='56.753'/>
            <Cube currency='SGD' rate='1.4874'/>
            <Cube currency='THB' rate='36.613'/>
            <Cube currency='ZAR' rate='15.9127'/>
        </Cube>
    </Cube>
</gesmes:Envelope>
EOS;
    }
}
