<?php

namespace Tests\Feature;

use App\Exports\EbayMotorsExport;
use App\Facades\Settings;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;
use Tests\UserForTenant;

class EbayMotorsExportTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testData()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'ebay enabled',
            'config_key' => 'sales-channels-ebay-motors-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        Vehicle::factory()->create([
            'is_published' => true,
            'description' => 'foo',
            'type' => 'car',
        ]);

        $vehicles = (new EbayMotorsExport())->collection();

        $this->assertCount(1, $vehicles);

        $vehicle = $vehicles->first();

        $this->assertEquals('foo', $vehicle['Description']);
        $this->assertEquals(0, $vehicle['PricePlusVat']);
    }
}
