<?php

namespace Tests\Feature;

use App\Crm\SendCopyViaMail;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Mockery\MockInterface;
use Mtc\Crm\Models\EnquiryAction;
use Mtc\MercuryDataModels\Enquiry;
use Tests\TestCase;
use Tests\UserForTenant;

class EnquiryControllerTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;

    protected $tenancy = true;

    public function testRetry()
    {
        $this->partialMock(SendCopyViaMail::class, function (MockInterface $mock) {
            $mock->shouldReceive('handle')->andReturn(true);
        });

        $enquiry = Enquiry::factory()->create();
        $action = EnquiryAction::factory()->create([
            'enquiry_id' => $enquiry->id,
            'action_name' => 'send-copy-via-mail',
            'attempts' => 5,
            'processed_at' => null,
        ]);

        $this->assertEquals(5, EnquiryAction::query()->first()->attempts);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('enquiries.resubmit-action', [$enquiry, $action]));

        $response->assertStatus(200);
        $this->assertEquals(0, EnquiryAction::query()->first()->attempts);
    }
}
