<?php

namespace Database\Seeders\MercuryTheme;

use Illuminate\Database\Seeder;
use Mtc\ContentManager\Facades\Page as PageFacade;
use Mtc\ContentManager\Models\Content;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Models\Template;
use Mtc\ContentManager\PageStatus;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Page::query()->truncate();
        Content::query()->truncate();

        collect($this->getList())
            ->each(function ($entry) {
                $page = PageFacade::create($entry['title'], $entry['template_id']);
                $page->update([
                    'slug' => $entry['slug'],
                    'status' => $entry['status'],
                ]);
        });
    }

    public function getList()
    {
        return [
            [
                'title' => 'Homepage',
                'slug' => 'home',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'home')->first()->id ?? 0,
            ],
            [
                'title' => 'Services',
                'slug' => 'services',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'services-list')->first()->id ?? 0,
            ],
            [
                'title' => 'Offers',
                'slug' => 'offers',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'offers-list')->first()->id ?? 0,
            ],
            [
                'title' => 'Locations',
                'slug' => 'locations',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'locations-list')->first()->id ?? 0,
            ],
            [
                'title' => 'Newsroom',
                'slug' => 'news',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'news-landing')->first()->id ?? 0,
            ],
            [
                'title' => 'Terms & Conditions',
                'slug' => 'terms-and-conditions',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'general')->first()->id ?? 0,
            ],
            [
                'title' => 'Privacy Policy',
                'slug' => 'privacy',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'general')->first()->id ?? 0,
            ],
            [
                'title' => 'About Us',
                'slug' => 'about-us',
                'status' => PageStatus::PUBLISHED->value,
                'template_id' => Template::query()->where('slug', 'general')->first()->id ?? 0,
            ],
        ];
    }
}
