@extends('crm::emails.layout-non-tenant', [
    'subject' => 'Orphaned taxonomies removed report',
])

@section('content')

    @if(!empty($orphaned_taxonomy_makes))
        <p>
            The following orphaned make taxonomy maps were removed:
        </p>
        <ul>
            @foreach($orphaned_taxonomy_makes as $make)
                <li>{{ $make->term }}</li>
            @endforeach
        </ul>
    @endif

    @if(!empty($orphaned_taxonomy_models))
        <p>
            The following orphaned model taxonomy maps were removed:
        </p>
        <ul>
            @foreach($orphaned_taxonomy_models as $model)
                <li>{{ $model->term }}</li>
            @endforeach
        </ul>
    @endif

    <p>This affects:</p>
    <ul>
        @foreach($affected_tenant_records as $tenant_name => $tenant_record)
            <li>{{ $tenant_name }}</li>
            <ul>
                @foreach($tenant_record as $record_type => $affected_records)
                    <li>{{ $record_type }}</li>

                    <ul>
                        @foreach($affected_records as $affected_record)
                            @if(@array_key_exists('vrm', $affected_record))
                                <li>{{ $affected_record['id'] }} {{ $affected_record['vrm'] }} {{ $affected_record['name'] }} {{ $affected_record['slug'] }}</li>
                            @else
                                <li>{{ $affected_record['id'] }} {{ $affected_record['name'] }} {{ $affected_record['slug'] }}</li>
                            @endif
                        @endforeach
                    </ul>

                @endforeach
            </ul>
        @endforeach
    </ul>


@endsection
