<?php

namespace App\Modules\Finance\Services;

use App\Contracts\AddsDealershipFields;
use App\Facades\Settings;

class CodeWeavers implements AddsDealershipFields
{
    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields(): array
    {
        return [
            'codeweavers' => [
                'type' => 'text',
                'label' => 'Dealer ID within CodeWeavers (for per-dealer finance checks)',
            ],
        ];
    }

    public function enabled(): bool
    {
        return Settings::get('finance-codeweavers-enabled', false);
    }
}
