<?php

declare(strict_types=1);

use App\Http\Controllers\ApiLogController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\AttributeController;
use App\Http\Controllers\AuditController;
use App\Http\Controllers\AutoImagingNotificationController;
use App\Http\Controllers\AutosOnShowNotificationController;
use App\Http\Controllers\AutoTraderHubNotificationController;
use App\Http\Controllers\BillingController;
use App\Http\Controllers\ExportMapController;
use App\Http\Controllers\ElementController;
use App\Http\Controllers\FeedController;
use App\Http\Controllers\ChecklistController;
use App\Http\Controllers\ColourMapController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DealershipController;
use App\Http\Controllers\FilterFeatureController;
use App\Http\Controllers\FranchiseController;
use App\Http\Controllers\GlobalContentController;
use App\Http\Controllers\ImportMapController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\MediaController as AppMediaController;
use App\Http\Controllers\NewCarController;
use App\Http\Controllers\OfferTypeController;
use App\Http\Controllers\OptionListController;
use App\Http\Controllers\PropertyCategoryController;
use App\Http\Controllers\PropertyController;
use App\Http\Controllers\ReservationController;
use App\Http\Controllers\ReservationStatusController;
use App\Http\Controllers\SalesChannelController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\SeoController;
use App\Http\Controllers\SeoDataController;
use App\Http\Controllers\SeoDefaultController;
use App\Http\Controllers\SeoHeadingController;
use App\Http\Controllers\SeoRedirectController;
use App\Http\Controllers\SiteDomainController;
use App\Http\Controllers\ReplacementController;
use App\Http\Controllers\TenantTaxonomyController;
use App\Http\Controllers\ValuationController;
use App\Http\Controllers\VehicleOfferController;
use App\Http\Middleware\InitializeTenancyByDomain;
use App\Modules\CatalogOffers\Http\Controllers\CatalogOfferController;
use App\Modules\ServiceBooking\Http\Controllers\BookingController;
use App\Modules\ServiceBooking\Http\Controllers\ServiceAvailabilityController;
use App\Modules\ServiceBooking\Http\Controllers\ServiceCalendarController;
use App\Modules\ServiceBooking\Http\Controllers\ServiceDeliveryController;
use App\Modules\ServiceBooking\Http\Controllers\ServicePackageController;
use App\Modules\Valuation\Http\Controllers\ValuationAdjustmentController;
use App\Modules\VehicleLabels\Http\Controllers\LabelController;
use App\Modules\VehicleTrims\Http\Controllers\VehicleTrimController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TemplateController;
use Mtc\Notifications\Http\Controllers\NotificationController;
use Stancl\Tenancy\Middleware\InitializeTenancyByPath;
use Stancl\Tenancy\Middleware\InitializeTenancyByRequestData;
use App\Master\Http\Controllers\UploadProfilePhotoController;
use App\Http\Controllers\BodyStyleController;
use App\Http\Controllers\DrivetrainController;
use App\Http\Controllers\FuelTypeController;
use App\Http\Controllers\MakeController;
use App\Http\Controllers\ModelController;
use App\Http\Controllers\PinnedItemController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\SiteUserController;
use App\Http\Controllers\TransmissionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VehicleController;
use Illuminate\Routing\Router;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::prefix('api')
    ->as('tenant.')
    ->middleware([
        'api',
        InitializeTenancyByRequestData::class,
        'auth:sanctum'
    ])
    ->group(function (Router $router) {
        $router->get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
        $router->post('/dashboard/graph', [DashboardController::class, 'graph']);
        $router->get('/dashboard/content', [DashboardController::class, 'content'])->name('content-dashboard');
        $router->get('/dashboard/crm', [DashboardController::class, 'crm'])->name('crm-dashboard');
        $router->get('/dashboard/taxonomies', [DashboardController::class, 'taxonomies'])->name('taxonomy-dashboard');
        $router->get('/bulk-import-log/{type}', [DashboardController::class, 'bulkImportLog'])->name('bulk-import-log');
        $router->post('/bulk-import-log/download-file/{log}', [DashboardController::class, 'bulkImportLogFile'])->name('download-import-log-file');
        $router->get('/sidebar', [DashboardController::class, 'sidebar'])->name('sidebar');
        $router->post('/search', [SearchController::class, 'index'])->name('search');
        $router->post('/search/elements', [SearchController::class, 'elements'])->name('search.content');
        $router->post('/search/vehicles', [SearchController::class, 'vehicles'])->name('search.vehicles');
        $router->get('/search/vehicles/filters', [SearchController::class, 'vehicleFilters'])->name('search.vehicle-filters');
        $router->get('/search/{type}/filters', [SearchController::class, 'getFilters']);


        $router->post('site-unmapped-taxonomies', [TenantTaxonomyController::class, 'index']);
        $router->put('site-unmapped-taxonomies/{map}', [TenantTaxonomyController::class, 'update']);

        $router->get('/audit', [AuditController::class, 'index'])->name('audit.index');
        $router->get('/audit/{audit}', [AuditController::class, 'show'])->name('audit.show');

        $router->get('/data/{type}', [OptionListController::class, 'index'])->name('data-list');

        // notifications
        $router->post('/notification-centre', [NotificationController::class, 'index'])->name('notifications.view');
        $router->put('/notification-centre/mark-read', [NotificationController::class, 'markRead'])->name('notifications.mark-read');
        $router->put('/notification-centre/mark-unread', [NotificationController::class, 'markUnread'])->name('notifications.mark-unread');
        $router->put('/notification-centre/delete', [NotificationController::class, 'destroy'])->name('notifications.delete');

        // users
        $router->get('/user/get-dashboard/{section}', [DashboardController::class, 'getDashboardWidgets'])->name('user.get-dashboard-widgets');
        $router->put('/user/set-dashboard/{section}', [DashboardController::class, 'setDashboardWidgets'])->name('user.set-dashboard-widgets');
        $router->get('/users', [UserController::class, 'siteUsers'])->name('users.index');
        $router->post('/user/profile-photo', [UploadProfilePhotoController::class, 'update'])
            ->name('users.profile');

        // pinned items
        $router->get('pinned-items', [PinnedItemController::class, 'show'])->name('pinned-items.index');
        $router->post('pinned-items', [PinnedItemController::class, 'store'])->name('pinned-items.store');
        $router->delete('pinned-items/{pinned_item_id}', [PinnedItemController::class, 'destroy'])->name('pinned-items.destroy');

        $router->group([
            'prefix' => 'checklists/',
            'as' => 'checklists.',
        ], function ($router) {
            $router->post('domain-check/{domain}', [ChecklistController::class, 'checkDomain'])->name('domain');
            $router->post('ssl-check/{domain}', [ChecklistController::class, 'checkSsl'])->name('ssl');
            $router->post('mail-check', [ChecklistController::class, 'checkMail'])->name('mail');
        });

        $router->group([
            'prefix' => 'settings/seo/',
            'as' => 'seo_settings.',
        ], function (Router $router) {
            $router->post('defaults', [SeoDefaultController::class, 'bulkUpdate']);
            $router->apiResource('defaults', SeoDefaultController::class)->only(['index', 'update']);
            $router->post('data/export', [SeoDataController::class, 'export'])->name('data.export');
            $router->post('data/import', [SeoDataController::class, 'import'])->name('data.import');
            $router->delete('data/bulk-delete', [SeoDataController::class, 'bulkDestroy'])->name('data.bulk-delete');
            $router->apiResource('data', SeoDataController::class);
            $router->post('redirects/export', [SeoRedirectController::class, 'export'])->name('redirects.export');
            $router->post('redirects/import', [SeoRedirectController::class, 'import'])->name('redirects.import');
            $router->post('redirects/verify', [SeoRedirectController::class, 'verify'])->name('redirects.verify');
            $router->delete('redirects/bulk-delete', [SeoRedirectController::class, 'bulkDestroy'])->name('redirects.bulk-delete');
            $router->apiResource('redirects', SeoRedirectController::class);
            $router->post('headings/export', [SeoHeadingController::class, 'export'])->name('headings.export');
            $router->post('headings/import', [SeoHeadingController::class, 'import'])->name('headings.import');
            $router->apiResource('headings', SeoHeadingController::class)->except(['show']);
        });

        $router->group([
            'prefix' => 'service-bookings',
            'as' => 'service-booking.',
        ], function (Router $router) {
            $router->post('calendar', [ServiceCalendarController::class, 'index'])->name('calendar');
            $router->apiResource('bookings', BookingController::class)->only(['index', 'show', 'update']);
            $router->apiResource('packages', ServicePackageController::class);
            $router->apiResource('availability', ServiceAvailabilityController::class)->only(['index', 'show', 'update', 'delete']);
            $router->apiResource('delivery', ServiceDeliveryController::class);
        });

        $router->post('/seo/check-slug', [SeoController::class, 'checkSlug'])->name('seo.check-slug');

        $router->post('/upload-asset', [AssetController::class, 'store']);
        $router->delete('/remove-asset', [AssetController::class, 'destroy']);

        $router->get('sales-channels/', [SalesChannelController::class, 'index'])->name('sales-channels.index');
        $router->get('sales-channels/{channel}', [SalesChannelController::class, 'show'])->name('sales-channels.show');
        $router->put('sales-channels/{channel}', [SalesChannelController::class, 'update'])->name('sales-channels.update');

        // settings & billing
        $router->apiResource('billing/invoices', InvoiceController::class)
            ->only(['index', 'show']);
        $router->get('settings/go-live-checklist', [SettingController::class, 'checklist'])->name('settings.checklist');

        $router->get('settings/import-maps/get/{model}', [ImportMapController::class, 'getForModel']);
        $router->post('settings/import-maps/{importMap}/upload', [ImportMapController::class, 'upload']);
        $router->apiResource('settings/import-maps', ImportMapController::class);

        $router->get('settings/export-maps/get/{model}', [ExportMapController::class, 'getForModel']);
        $router->apiResource('settings/export-maps', ExportMapController::class);

        $router->get('settings/billing', [BillingController::class, 'index'])
            ->name('settings.billing.index');
        $router->put('settings/billing/subscription', [BillingController::class, 'updateSubscription'])
            ->name('settings.billing.update-subscription');
        $router->put('settings/billing/details', [BillingController::class, 'updateDetails'])
            ->name('settings.billing.update-details');
        $router->put('settings/domains/{domain}/make-primary', [SiteDomainController::class, 'makePrimary']);
        $router->put('settings/domains/{domain}/force', [SiteDomainController::class, 'force']);
        $router->apiResource('settings/domains', SiteDomainController::class)->only(['index', 'store', 'destroy']);
        $router->get('settings/site-users', [SiteUserController::class, 'show'])
            ->name('settings.site-users.show');
        $router->post('settings/site-users', [SiteUserController::class, 'store'])
            ->name('settings.site-users.store');
        $router->put('settings/site-users', [SiteUserController::class, 'update'])
            ->name('settings.site-users.update');
        $router->delete('settings/site-users', [SiteUserController::class, 'destroy'])
            ->name('settings.site-users.destroy');
        $router->get('settings/replacements', [ReplacementController::class, 'show'])
            ->name('settings.replacements.show');
        $router->get('settings/replacements-types', [ReplacementController::class, 'showTypes'])
            ->name('settings.replacements.show-types');
        $router->post('settings/replacements', [ReplacementController::class, 'store'])
            ->name('settings.replacements.store');
        $router->put('settings/replacements/{replacement}', [ReplacementController::class, 'update'])
            ->name('settings.replacements.update');
        $router->delete('settings/replacements/{replacement}', [ReplacementController::class, 'destroy'])
            ->name('settings.replacements.destroy');
        $router->post('settings/verify', [SettingController::class, 'verify']);
        $router->post('settings/trigger-action', [SettingController::class, 'triggerAction']);
        $router->get('settings', [SettingController::class, 'index'])
            ->name('settings.index');
        $router->get('settings/search', [SettingController::class, 'search']);
        $router->get('settings/{tab}', [SettingController::class, 'show'])
            ->name('settings.show');
        $router->put('settings/{section}', [SettingController::class, 'update'])
            ->name('settings.update');
        $router->post('settings', [SettingController::class, 'store'])
            ->name('settings.store');

        // taxonomies
        $router->resource('vehicle-taxonomies/makes', MakeController::class)->only(['index', 'show']);
        $router->get('vehicle-taxonomies/makes/{make_id}/models', [ModelController::class, 'index'])
            ->name('make-models');
        $router->get('vehicle-taxonomies/models/{model}', [ModelController::class, 'show'])->name('models');
        $router->resource('vehicle-taxonomies/drivetrains', DrivetrainController::class)->only(['index', 'show']);
        $router->resource('vehicle-taxonomies/transmissions', TransmissionController::class)->only([
            'index',
            'show'
        ]);
        $router->resource('vehicle-taxonomies/fuel-types', FuelTypeController::class)->only(['index', 'show']);
        $router->resource('vehicle-taxonomies/body-styles', BodyStyleController::class)->only(['index', 'show']);

        $router->resource('currencies', CurrencyController::class)->only(['index']);

        $router->apiResource('{model}/attributes', AttributeController::class);

        // vehicles
        $router->get('vehicles/featured', [VehicleController::class, 'getFeatured'])->name('vehicles.get-featured');
        $router->get('vehicles/warnings', [VehicleController::class, 'getWarnings'])->name('vehicles.get-warnings');
        $router->put('vehicles/featured', [VehicleController::class, 'setFeatured'])
            ->name('vehicles.set-featured');
        $router->post('vehicles/{vehicle}/get-finance', [VehicleController::class, 'getFinance'])
            ->name('vehicles.get-finance');
        $router->post('vehicles/{vehicle}/get-cap-id', [VehicleController::class, 'getCapId'])
            ->name('vehicles.get-cap-id');
        $router->post('vehicles/{vehicle}/get-ai-description', [VehicleController::class, 'getAIDescription'])
            ->name('vehicles.get-ai-description');
        $router->post('vehicles/{vehicle}/get-spec', [VehicleController::class, 'getSpec'])
            ->name('vehicles.get-spec');
        $router->post('vehicles/{vehicle}/copy', [VehicleController::class, 'copy'])->name('vehicles.copy');
        $router->post('vehicles/{vehicle}/set-status', [VehicleController::class, 'updateStatus'])
            ->name('vehicles.set-status');
        $router->post('vehicles/{vehicle}/get-images', [VehicleController::class, 'getImages'])
            ->name('vehicles.get-images');
        $router->post('vehicles/export/{exportMap?}', [VehicleController::class, 'export'])
            ->name('vehicles.export');
        $router->post('vehicles/import/{type?}', [VehicleController::class, 'import'])
            ->name('vehicles.import');

        $router->post('vehicle-lookup', [VehicleController::class, 'lookup']);
        $router->any('vehicle-search', [VehicleController::class, 'index']);
        $router->apiResource('vehicles', VehicleController::class);

        $router->get('franchises/{franchise}/usage', [FranchiseController::class, 'usage'])->name('franchise.usage');
        $router->post('franchises/{franchise}/copy', [FranchiseController::class, 'copy'])->name('franchise.copy');
        $router->apiResource('franchises', FranchiseController::class);
        $router->post('valuation-search', [ValuationController::class, 'index']);
        $router->apiResource('valuations', ValuationController::class)->only(['index', 'store', 'show']);
        $router->apiResource('offer-types', OfferTypeController::class);
        $router->apiResource('valuation-adjustments', ValuationAdjustmentController::class)->middleware('enabled-feature:valuation_adjustments');

        $router->get('content/global-elements/get-for-element/{element}', [GlobalContentController::class, 'forElement'])->name('global-content.for-element');
        $router->get('content/templates/{template}/usage', [TemplateController::class, 'usage'])->name('templates.usage');
        $router->get('content/templates/{template}/sync-all-usage', [TemplateController::class, 'syncUsage'])->name('templates.sync-usage');

        $router->get('content/elements/{element}/sync-all-usage', [ElementController::class, 'syncUsage'])->name('elements.sync-usage');

        // offers
        $router->post('vehicle-offers/{vehicleOffer}/sync-template-fields', [VehicleOfferController::class, 'syncWithTemplate'])
            ->name('vehicle-offers.sync-template');
        $router->post('vehicle-offers/{vehicleOffer}/copy', [VehicleOfferController::class, 'copy'])
            ->name('vehicle-offers.copy');
        $router->post('vehicle-offers/{vehicleOffer}/restore-version/{version}', [VehicleOfferController::class, 'restoreVersion'])
            ->name('vehicle-offers.restore-version');
        $router->post('vehicle-offers/export', [VehicleOfferController::class, 'export'])
            ->name('vehicle-offers.export');
        $router->post('vehicle-offers/{vehicleOffer}/get-ai-description', [VehicleOfferController::class, 'getAIDescription'])
            ->name('vehicles-offers.get-ai-description');
        $router->post('vehicle-offers/import', [VehicleOfferController::class, 'import'])
            ->name('vehicle-offers.import');
        $router->get('vehicle-offers/featured', [VehicleOfferController::class, 'getFeatured'])
            ->name('vehicle-offers.get-featured');
        $router->put('vehicle-offers/featured', [VehicleOfferController::class, 'setFeatured'])
            ->name('vehicle-offers.set-featured');
        $router->apiResource('vehicle-offers', VehicleOfferController::class);

        // new cars
        $router->post('new-cars/{newCar}/sync-template-fields', [NewCarController::class, 'syncWithTemplate'])
            ->name('new-cars.sync-template');
        $router->post('new-cars/{newCar}/copy', [NewCarController::class, 'copy'])->name('new-cars.copy');
        $router->post('new-cars/{newCar}/restore-version/{version}', [NewCarController::class, 'restoreVersion'])
            ->name('new-cars.restore-version');
        $router->apiResource('new-cars', NewCarController::class);

        // dealerships
        $router->post('dealerships/{dealership}/copy', [DealershipController::class, 'copy'])->name('dealerships.copy');
        $router->post('dealerships/{dealership}/sync-template-fields', [DealershipController::class, 'syncWithTemplate'])
            ->name('dealerships.sync-template');
        $router->apiResource('dealerships', DealershipController::class);


        $router->get('filter-features/search', [FilterFeatureController::class, 'search'])->name('filter-features.search');
        $router->apiResource('filter-features', FilterFeatureController::class);
        $router->apiResource('labels', LabelController::class);

        $router->apiResource('vehicle-trims', VehicleTrimController::class);
        $router->post('vehicle-trims/{vehicle_trim}/copy', [VehicleTrimController::class, 'copy']);

        $router->apiResource('catalog-offers', CatalogOfferController::class);

        $router->apiResource('reservations', ReservationController::class)->only(['index', 'show', 'update', 'destroy'])->middleware('enabled-feature:reservations');
        $router->apiResource('reservation-statuses', ReservationStatusController::class)->only(['index', 'store', 'show', 'update', 'destroy'])->middleware('enabled-feature:reservations');

        $router->post('property-categories/{category:slug}/properties/reorder', [PropertyController::class, 'reorder'])->name('properties.reorder')->middleware('permission:manage-properties');
        $router->apiResource('property-categories/{category:slug}/properties', PropertyController::class)->middleware('permission:manage-properties');
        $router->apiResource('property-categories', PropertyCategoryController::class)->except('index')->middleware('permission:manage-property-categories');
        $router->get('property-categories', [PropertyCategoryController::class, 'index'])->name('property-categories.index')->middleware('permission:manage-properties');

        $router->get('colour-map', [ColourMapController::class, 'index'])->name('colour-map.index');
        $router->put('colour-map', [ColourMapController::class, 'update'])->name('colour-map.update');

        $router->get('sites/roles', [SiteUserController::class, 'roles'])->name('sites.roles');
        $router->get('api-logs', [ApiLogController::class, 'index']);
    });


Route::prefix('api')
    ->middleware([
        'api',
        InitializeTenancyByDomain::class,
    ])
    ->group(function (Router $router) {
        $router->post('/media/{mediaUse}/crop-size', [AppMediaController::class, 'cropMediaSize'])->name('media.crop-size');
    });

Route::prefix('api/notifications/{tenant}/')
    ->as('tenant.notifications.')
    ->middleware([
        'api',
        InitializeTenancyByPath::class,
    ])
    ->group(function (Router $router) {
        $router->post('autos-on-show', [AutosOnShowNotificationController::class, 'store'])->name('autos-on-show');
        $router->get('auto-imaging', [AutoImagingNotificationController::class, 'index'])->name('auto-imaging.index');
        $router->post('auto-imaging', [AutoImagingNotificationController::class, 'store'])->name('auto-imaging.store');
        $router->post('auto-trader-hub', [AutoTraderHubNotificationController::class, 'store'])->name('auto-trader-hub.store');
    });

Route::prefix('api/feeds/{tenant}/')
    ->as('tenant.feeds.')
    ->middleware([
        'api',
        InitializeTenancyByPath::class,
    ])
    ->group(function (Router $router) {
        $router->get('channable', [FeedController::class, 'channable'])->name('channable');
        $router->get('phyron', [FeedController::class, 'phyron'])->name('phyron');
        $router->get('facebook', [FeedController::class, 'facebook'])->name('facebook');
        $router->get('google', [FeedController::class, 'google'])->name('google');
    });
