<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Jobs\CarSnipExportJob;
use App\Modules\SalesChannels\CarSnip;
use Database\Seeders\Tenant\CarSnipExportSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\Storage;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;

class CarSnipExportTest extends TestCase
{
    use RefreshDatabase;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testExportJob()
    {
        Storage::fake('car-snip-export');
        $this->seed(CarSnipExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-snip-file-name', 'foo.csv');

        $this->dispatch(new CarSnipExportJob());

        Storage::disk('car-snip-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-snip')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }

    public function testSalesChannelClass()
    {
        Storage::fake('car-snip-export');
        $this->seed(CarSnipExportSeeder::class);
        Vehicle::factory(10)->create();
        Settings::update('sales-channels-car-snip-file-name', 'foo.csv');
        Settings::update('sales-channels-car-snip-enabled', true);

        app(CarSnip::class)->runScheduledExport();

        Storage::disk('car-snip-export')->assertExists('foo.csv');
        $logged = SalesChannelHistory::query()
            ->where('channel', 'car-snip')
            ->where('was_successful', true)
            ->exists();
        $this->assertTrue($logged);
    }
}
