<?php

namespace Tests\Feature;

use App\Facades\Feature;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class FeatureTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testIsEnabled()
    {
        $this->assertFalse(Feature::isEnabled('valuation_adjustments'));
        tenant()->features()->updateOrCreate(['feature' => 'valuation_adjustments']);
        $this->assertTrue(Feature::isEnabled('valuation_adjustments', true));
    }

    public function testGetAll()
    {
        $enabled = Feature::getAll();
        $this->assertEquals(19, $enabled->count());
        $this->assertTrue($enabled->has('valuation_adjustments') !== false);
    }

    public function testEnabledForTenant()
    {
        $enabled = Feature::enabledForTenant();
        $this->assertEquals(0, $enabled->count());

        tenant()->features()->updateOrCreate(['feature' => 'valuation_adjustments']);
        $enabled = Feature::enabledForTenant();
        $this->assertEquals(1, $enabled->count());
        $this->assertTrue($enabled->has('valuation_adjustments') !== false);

    }

    public function testSetEnabled()
    {
        $this->assertFalse(Feature::isEnabled('valuation_adjustments'));
        Feature::setEnabled(tenant(), ['valuation_adjustments']);
        $this->assertTrue(Feature::isEnabled('valuation_adjustments'));
    }
    public function testValuationAdjustment()
    {
        Feature::setEnabled(tenant(), ['valuation_adjustments']);
        $this->assertTrue(Feature::isEnabled('valuation_adjustments'));
        $features = Feature::enabledForTenant();
        $this->assertEquals(__('features.valuation_adjustment.title'), $features->first()->name());
        $this->assertEquals(__('features.valuation_adjustment.description'), $features->first()->description());
    }
}
