<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\DatabaseMigrations;
use App\Master\Models\BodyStyleType;
use App\Master\Models\DrivetrainType;
use App\Master\Models\FuelType;
use App\Master\Models\TransmissionType;
use App\Master\Models\VehicleMake;
use App\Master\Models\VehicleModel;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class MasterTaxonomyControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    public function testMakeIndex()
    {
        VehicleMake::factory(15)->create();

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/make');


        $response->assertStatus(200);
        $this->assertEquals(15, $response->json('total'));
    }

    public function testMakeShow()
    {
        $model = VehicleMake::factory()->create(['name' => 'BMW']);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/make/' . $model->id);

        $response->assertStatus(200);
        $this->assertEquals('BMW', $response->json('name'));
    }

    public function testModelsIndex()
    {
        $make = VehicleMake::factory()->create();
        VehicleModel::factory(14)->create(['make_id' => $make->id]);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/model/');

        $response->assertStatus(200);
        $this->assertEquals(14, $response->json('total'));
    }

    public function testModelsShow()
    {
        $model = VehicleModel::factory()->create(['name' => '3.series']);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/model/' . $model->id);

        $response->assertStatus(200);
        $this->assertEquals('3.series', $response->json('name'));
    }

    public function testDrivetrainIndex()
    {
        DrivetrainType::factory(13)->create();

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/drivetrain');


        $response->assertStatus(200);
        $this->assertEquals(13, $response->json('total'));
    }

    public function testDrivetrainShow()
    {
        $model = DrivetrainType::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/drivetrain/' . $model->id);

        $response->assertStatus(200);
        $this->assertEquals('foo', $response->json('name'));
    }

    public function testTransmissionIndex()
    {
        TransmissionType::factory(12)->create();

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/transmission');

        $response->assertStatus(200);
        $this->assertEquals(12, $response->json('total'));
    }

    public function testTransmissionShow()
    {
        $model = TransmissionType::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/transmission/' . $model->id);

        $response->assertStatus(200);
        $this->assertEquals('foo', $response->json('name'));
    }

    public function testFuelTypeIndex()
    {
        FuelType::factory(11)->create();

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/fuel_type');

        $response->assertStatus(200);
        $this->assertEquals(11, $response->json('total'));
    }

    public function testFuelTypeShow()
    {
        $fuel_type = FuelType::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/fuel_type/' . $fuel_type->id);

        $response->assertStatus(200);
        $this->assertEquals('foo', $response->json('name'));
    }

    public function testBodyStyleSIndex()
    {
        BodyStyleType::factory(10)->create();

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/body_type');

        $response->assertStatus(200);
        $this->assertEquals(10, $response->json('total'));
    }

    public function testBodyStyleShow()
    {
        $body_style = BodyStyleType::factory()->create(['name' => 'foo']);

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/body_type/' . $body_style->id);

        $response->assertStatus(200);
        $this->assertEquals('foo', $response->json('name'));
    }

    public function testUnmapped()
    {
        VehicleMake::factory(15)->create();

        $response = $this->actingAs($this->getUser())
            ->getJson('/api/taxonomies/unmapped');


        $response->assertStatus(200);
        $this->assertArrayHasKey('master-make', $response->json());
        $this->assertArrayHasKey('master-model', $response->json());
        $this->assertArrayHasKey('master-body_style', $response->json());
        $this->assertArrayHasKey('master-drivetrain', $response->json());
        $this->assertArrayHasKey('master-transmission', $response->json());
        $this->assertArrayHasKey('master-fuel_type', $response->json());
    }

}
