<?php

namespace Tests\Feature;

use Database\Seeders\Tenant\SeoSettingSeeder;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\SeoDefault;
use Mtc\MercuryDataModels\OfferType;
use Mtc\MercuryDataModels\Template;
use Mtc\MercuryDataModels\Vehicle;
use Tests\TestCase;
use Tests\UserForTenant;

class OfferTypeTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testIndex()
    {
        OfferType::factory(10)->create();
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.offer-types.index'));

        $response->assertStatus(200);
        $this->assertEquals(10, $response->json('total'));
    }

    public function testShow()
    {
        $offerType = OfferType::factory()->create();
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.offer-types.show', $offerType));

        $response->assertStatus(200);
        $this->assertArrayHasKey('type', $response->json());
        $this->assertArrayHasKey('templates', $response->json());
        $this->assertEquals($offerType->id, $response->json('type.id'));
        $this->assertEquals($offerType->template_id, $response->json('type.template_id'));
    }

    public function testStore()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.offer-types.store'), [
                'name' => 'foo',
            ]);

        $response->assertStatus(201);
        $this->assertArrayHasKey('type', $response->json());
        $this->assertArrayHasKey('templates', $response->json());
        $this->assertEquals('foo', $response->json('type.name'));
    }

    public function testUpdate()
    {
        $template = Template::factory()->create();
        $offerType = OfferType::factory()->create();
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.offer-types.update', $offerType), [
                'name' => 'foo',
                'template_id' => $template->id,
                'slug' => 'foo-slug',
            ]);

        $response->assertStatus(200);
        $this->assertArrayHasKey('type', $response->json());
        $this->assertArrayHasKey('templates', $response->json());
        $this->assertEquals('foo', $response->json('type.name'));
        $this->assertEquals($template->id, $response->json('type.template_id'));
    }

    public function testDestroy()
    {
        $offerType = OfferType::factory()->create();
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->deleteJson(route('tenant.offer-types.destroy', $offerType));

        $response->assertStatus(200);
        $this->assertFalse(OfferType::query()->where('id', $offerType->id)->exists());
    }
}
