<?php

namespace Tests\Feature;

use Carbon\Carbon;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\VehicleReservations\Reservation;
use Tests\TestCase;
use Tests\UserForTenant;

class ReservationTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testIndex()
    {
        tenant()->features()->updateOrCreate(['feature' => 'reservations']);

        $vehicle = Vehicle::factory()->create();
        Reservation::factory()->create([
            'vehicle_id' => $vehicle->id,
            'data' => null,
            'confirmed_at' => Carbon::now(),
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.reservations.index'));

        $response->assertStatus(200);

        $this->assertStringContainsString($vehicle->registration_number, $response->json('data.0.metaItems.vehicle_description'));
    }

    public function testIndexWithReservationData()
    {
        tenant()->features()->updateOrCreate(['feature' => 'reservations']);

        $vehicle = Vehicle::factory()->create();
        Reservation::factory()->create([
            'vehicle_id' => $vehicle->id,
            'data' =>[
                'vehicle' => [
                    'description' => 'foo',
                ],
            ],
            'confirmed_at' => Carbon::now(),
        ]);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.reservations.index'));

        $response->assertStatus(200);

        $this->assertEquals('foo', $response->json('data.0.metaItems.vehicle_description'));
    }
}
