<?php

namespace Tests\Feature;

use App\Facades\Site;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use Tests\UserForTenant;

class SiteRepositoryTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testGetSiteUrl()
    {
        tenant()->domains()->update([
            'verified' => true,
        ]);
        $url = Site::url('/foo');

        $this->assertEquals('https://test.localhost/foo', $url);
    }
}
