<?php

namespace Tests\Feature;

use App\Facades\Settings;
use App\Modules\Valuation\Config\AutoTrader;
use App\Modules\Valuation\Config\CapConfig;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Facades\App;
use Tests\TestCase;
use Tests\UserForTenant;

class ValuationConfigTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testAutoTrader()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'type' => 'boolean',
            'value' => false,
            'config_key' => 'valuation-auto-trader-enabled'
        ]);
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'type' => 'string',
            'value' => 'foo-baz-bar',
            'config_key' => 'auto-trader-advertiser-id'
        ]);
        /** @var AutoTrader $config */
        $config = App::make(AutoTrader::class);
        $this->assertFalse($config->enabled());
        $this->assertEquals('foo-baz-bar', $config->merchantId());

        Settings::update('valuation-auto-trader-enabled', true);
        $this->assertTrue($config->enabled());
    }

    public function testCap()
    {
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'type' => 'boolean',
            'value' => false,
            'config_key' => 'valuation-cap-enabled'
        ]);
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'type' => 'string',
            'value' => 'foo-baz-bar',
            'config_key' => 'valuation-cap-subscriber_id'
        ]);
        Settings::make([
            'tab' => 'foo-baz',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'type' => 'string',
            'value' => 'lorem-ipsum',
            'config_key' => 'valuation-cap-password'
        ]);
        /** @var CapConfig $config */
        $config = App::make(CapConfig::class);
        $this->assertFalse($config->enabled());
        $this->assertEquals('foo-baz-bar', $config->subscriberId());
        $this->assertEquals('lorem-ipsum', $config->password());

        Settings::update('valuation-cap-enabled', true);
        $this->assertTrue($config->enabled());
    }

}
