<?php

namespace Tests\Feature;

use App\DashboardRepository;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\App;
use Mtc\MercuryDataModels\SeoData;
use Mtc\MercuryDataModels\UserDashboardWidget;
use Tests\TestCase;
use Tests\UserForTenant;

class WidgetTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testGetDefaultWidgets()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson('/api/dashboard');

        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('kind', $response->json('0'));
        $this->assertArrayHasKey('widget', $response->json('0'));
        $this->assertArrayHasKey('data', $response->json('0'));
    }

    public function testGetAvailableWidgets()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.user.get-dashboard-widgets', 'home'));

        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertArrayHasKey('kind', $response->json('0'));
        $this->assertArrayHasKey('widget', $response->json('0'));
        $this->assertArrayHasKey('data', $response->json('0'));
    }

    public function testSetAndLoadUserSpecificWidgets()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->putJson(route('tenant.user.set-dashboard-widgets', 'home'), [
                'widgets' => [
                    [
                        'widget' => 'enquiries',
                        'data' => [],
                    ],
                    [
                        'widget' => 'recent-vehicles',
                        'data' => [],
                    ],
                ]
            ]);

        $response->assertStatus(200);

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson('/api/dashboard');

        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertCount(2, $response->json());
        $this->assertEquals('enquiries', $response->json('0.widget'));
        $this->assertEquals('recent-vehicles', $response->json('1.widget'));

    }

    public function testLoadCustomSectionWidgets()
    {
        $repository = App::make(DashboardRepository::class);
        $response = $repository->load($this->getUser(), 'custom');
        $this->assertIsArray($response);
        $this->assertCount(0, $response);
    }
}
