<?php

namespace Tests;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Testing\RefreshDatabase;

abstract class TenantTestCase extends \Orchestra\Testbench\TestCase
{
    use CreatesApplication;
    use RefreshDatabase;
    use DispatchesJobs;

    protected $connectionsToTransact = [
        'sqlite',
    ];

    protected function setUp(): void
    {
        parent::setUp();
    }
    protected function migrateFreshUsing()
    {
        return [
            '--schema-path' => database_path('schema/test-tenant-schema.sql'),
            '--path' => database_path('migrations/tenant'),
            '--realpath' => true,
        ];
    }
}
