<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class UpdateSeoDataRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'path' => [
                'required',
                'unique:seo_data,path,' . $this->data?->id,
            ],
            'title' => [
                'required_without:heading',
                'max:250',
            ],
            'description' => [
                'required_without:heading',
                'max:250',
            ],
            'heading' => [
                'required_without:title,description',
                'max:250',
            ],
        ];
    }
}
