<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CalltracksSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Calltracks',
                'name' => 'Enabled',
                'config_key' => 'crm-calltracks-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://barbuck.com/calltracks/" target="_blank">Calltracks</a>'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Calltracks',
                'name' => 'Calltracks system',
                'config_key' => 'crm-calltracks-system',
                'type' => 'string',
                'value' => 'lite',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.crm-calltracks-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Calltracks',
                'name' => 'Tags with numbers',
                'config_key' => 'crm-calltracks-tags',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'validation_rules' => [
                    "required_if:values.crm-calltracks-enabled,true"
                ]
            ],
        ];
    }
}
