<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class ImaginStudioZoomLevelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Content',
                'group' => __('features.imagin_placeholders.title'),
                'name' => 'Zoom level',
                'config_key' => 'imagin-placeholders-zoom-level',
                'value' => '',
                'type' => 'number',
            ]
        ];
    }
}



