<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ServiceAvailabilityView extends JsonResource
{
    public static $wrap = '';

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->load('serviceAvailability.upcomingHolidays');
        $this->resource->setVisible([
            'id',
            'name',
        ]);

        $availability = $this->resource->serviceAvailability?->toArray();
        $availability['holidays'] = $this->resource->serviceAvailability
            ?->upcomingHolidays
            ?->pluck('holiday_date') ?? [];
        return [
            'location' => $this->resource,
            'availability' => $availability,
        ];
    }
}
