<?php

namespace App\Listeners;

use App\Events\VehicleUpdated;
use App\Facades\Settings;
use App\Jobs\ExportVehicleToAutoTrader;
use App\Services\AutoTraderHub;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class SendVehicleToAutoTrader implements ShouldQueue
{
    use InteractsWithQueue;

    public function __construct(private readonly AutoTraderHub $autoTraderHub)
    {
        //
    }

    public function handle(VehicleUpdated $event)
    {
        if (!Settings::get('sales-channels-auto-trader-enabled') || !Settings::get('auto-trader-hub-token')) {
            return;
        }

        ExportVehicleToAutoTrader::dispatch($event->getVehicle(), $this->autoTraderHub);
    }
}
