<?php

return [
    'auto_load_migrations' => false,
    'load_routes' => false,

    'form_actions' => [
        'send-copy-via-mail' => \App\Crm\SendCopyViaMail::class,
        'send-to-rapid-rtc' => \App\Crm\SendToRapidRTC::class,
        'send-to-enquiry-max' => \App\Crm\SendToEnquiryMax::class,
        'send-to-dealer-web-lms' => \App\Crm\SendToDealerWebLms::class,
        'send-to-brevo' => \App\Crm\SendToBrevo::class,
        'send-to-salesforce' => \App\Crm\SendToSalesforce::class,
    ],

    'user_model' => \Mtc\MercuryDataModels\User::class,

    'customer_model' => \Mtc\MercuryDataModels\Customer::class,
    'customer_view_resource' => \App\Http\Resources\CustomerView::class,

    'form_model' => \Mtc\MercuryDataModels\Form::class,
    'form_section_model' => \Mtc\MercuryDataModels\FormSection::class,
    'enquiry_model' => \Mtc\MercuryDataModels\Enquiry::class,

    'form_repository_class' => \App\FormRepository::class,
    'enquiry_repository_class' => \App\EnquiryRepository::class,
    'form_view_resource' => \App\Http\Resources\FormViewResource::class,

    'enquiry_list_resource' => \App\Http\Resources\EnquiryList::class,
    'enquiry_view_resource' => \App\Http\Resources\EnquiryViewResource::class,

    'new_enquiry_email' => \App\Mail\NewEnquiryMail::class,
    'enquiry_confirmation_mail' => \App\Mail\NewEnquiryCustomerCopyNotification::class,

    'route_middleware' => [
        'enquiries' => ['permission:view-enquiries'],
        'forms' => ['permission:edit-forms'],
    ],

    'new_booking_confirmation_email' => \App\Mail\NewBookingConfirmationMail::class,
    'new_booking_email' => \App\Mail\NewBookingMail::class,

    'enquiry_action_max_attempts' => env('ENQUIRY_ACTION_MAX_ATTEMPTS', 3)
];
