<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Support\Facades\Auth;
use Mtc\PinnedItems\Facades\PinnedItems;
use Mtc\PinnedItems\Models\PinnedItemModel;
use Tests\TestCase;
use Tests\UserForTenant;

class PinnedItemControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testShow()
    {
        PinnedItems::addUrl($this->getUser(), '/foo', '', 'baz', 'bar');
        PinnedItems::addUrl($this->getUser(), '/foo2', '', 'baz2', 'bar2');
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->getJson(route('tenant.pinned-items.index'));

        $response->assertStatus(200);
        $this->assertIsArray($response->json());
        $this->assertCount(2, $response->json());
    }

    public function testStore()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.pinned-items.store'), [
                'url' => '/foo',
                'title' => 'baz',
                'subtitle' => 'bar',
            ]);

        $response->assertStatus(200);

        $this->assertIsArray($response->json());
        $this->assertCount(1, $response->json());
    }

    public function testDestroy()
    {
        PinnedItems::addUrl($this->getUser(), '/foo', '', 'baz', 'bar');
        PinnedItems::addUrl($this->getUser(), '/baz', '', 'baz', 'bar');

        $pinned = PinnedItemModel::query()->where('pinned_url', '/foo')->first();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->deleteJson(route('tenant.pinned-items.destroy', $pinned));

        $response->assertStatus(200);

        $items = PinnedItems::get($this->getUser());
        $this->assertTrue($items->filter(fn ($item) => $item['url'] === '/foo')->isEmpty());
    }
}
