<?php

namespace Tests\Feature;

use App\Events\NewVehicleImported;
use App\Facades\Settings;
use App\VehicleSpec\Config\AutoTraderConfig;
use App\VehicleSpec\Contracts\VehicleStandardEquipmentItem;
use App\VehicleSpec\Contracts\VehicleTechnicalDataItem;
use App\VehicleSpec\Jobs\FetchVehicleSpecData;
use App\VehicleSpec\Jobs\VehicleCapIdLookup;
use App\VehicleType;
use Database\Seeders\Tenant\AutoTraderStockSettingSeeder;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Queue;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleStandardEquipment;
use Mtc\MercuryDataModels\VehicleTechnicalData;
use App\VehicleSpec\Config\CapConfig;
use App\VehicleSpec\Contracts\VehicleSpecData;
use App\VehicleSpec\Services\Cap;
use App\VehicleSpec\VehicleSpecServiceHelper;
use Database\Seeders\Tenant\VehicleSpecSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\MercuryDataModels\VehicleSpecType;
use Tests\TenantTestCase;
use Tests\TestCase;
use Tests\UserForTenant;

class VehicleSpecControllerTest extends TestCase
{
    use RefreshDatabase;
    use UserForTenant;

    protected $tenancy = true;

    public function testQueueSpecImportJob()
    {
        $this->seed(VehicleSpecSeeder::class);

        Queue::fake();

        $vehicle = Vehicle::factory()->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->postJson(route('tenant.vehicles.get-spec', $vehicle));

        $response->assertStatus(200);

        Queue::assertPushed(FetchVehicleSpecData::class);
    }
}
