<?php

namespace App;

use App\Facades\Settings;
use App\Traits\RetrievesFieldData;
use App\Traits\SavesContent;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Mtc\ContentManager\Facades\Media;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\DealershipFinance;

class DealershipRepository
{
    use RetrievesFieldData;
    use SavesContent;

    protected static array $dataFields = [
        'template_id',
    ];

    /**
     * Save Page
     *
     * @param Dealership $dealership
     * @param Request $request
     * @return void
     */
    public function saveContent(Dealership $dealership, Request $request)
    {
        $this->dropOrphanedContent($dealership, $this->getFlatContentElementIds($request->input('content')));

        collect($request->input('content'))
            ->each(fn($element, $index) => $this->saveContentElement($dealership, $element, $index));
    }

    public function hasVersioning(): bool
    {
        return Settings::get('dealership-versioning-enabled') === true
            && TierHelper::isAllowed(tenant('tier'), Tier::STANDARD->value);
    }

    protected function elementParentColumnName(): string
    {
        return 'dealership_id';
    }

    protected function contentOwnerType(): string
    {
        return 'dealership-version';
    }

    protected function getQuery(): Builder
    {
        return Dealership::query();
    }
}
