<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LabelFilterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Filter by labels',
                'config_key' => 'automotive-vehicle-filters-labels',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Hide from UI',
                'name' => 'Hide labels section',
                'config_key' => 'automotive-vehicle-filters-labels_hide_in_ui',
                'type' => 'boolean',
                'description' => 'When enabled filter will be active and functional, but will not show up in UI',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Hide from UI',
                'name' => 'Hide vehicle type section',
                'config_key' => 'automotive-vehicle-filters-vehicle_type_hide_in_ui',
                'type' => 'boolean',
                'description' => 'When enabled filter will be active and functional, but will not show up in UI',
            ],
        ];
    }
}
