<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CapSpecsRepeatedChecksSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Specification / Feature Synchronization',
                'group' => 'CAP',
                'name' => 'Continuous checks for CAP ID',
                'config_key' => 'vehicle-spec-providers-cap-repeated-checks',
                'type' => 'boolean',
                'value' => true,
                'description' => 'If CAP ID was not found during initial import, continue to check if details '
                    . 'have become available daily',
            ],
        ];
    }
}
