<?php

namespace App\Http\Controllers;

use App\Http\Requests\AutoTraderHubNotification;
use App\Jobs\HandleAutoTraderHubNotification;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Mtc\MercuryDataModels\ApiNotification;

class AutoTraderHubNotificationController extends Controller
{
    use DispatchesJobs;

    public function store(AutoTraderHubNotification $request)
    {
        $apiNotification = ApiNotification::query()
            ->create([
                'provider' => 'auto-trader-hub',
                'data' => $request->input(),
                'headers' => $request->header(),
                'data_model' => 'vehicle',
                'reference' => $request->input('stock_id'),
            ]);

        $this->dispatch(new HandleAutoTraderHubNotification($request->input(), $apiNotification));

        return response([
            'status' => 'received'
        ]);
    }
}
