<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class SystemAlert extends Model
{
    use CentralConnection;
    use HasFactory;


    protected $fillable = [
        'alert_type',
        'alert_time_condition',
        'last_sent_at',
        'tenant_id',
    ];

    /**
     * Treat "last_sent_at" as a datetime/Carbon instance.
     */
    protected $casts = [
        'last_sent_at' => 'datetime',
    ];

    /**
     * Optionally override the factory the model should use.
     */
    protected static function newFactory()
    {
        return \Database\Factories\SystemAlertFactory::new();
    }

    public function subscribers(): BelongsToMany
    {
        return $this->belongsToMany(User::class, 'system_alert_subscribers', 'system_alert_id', 'user_id');
    }
}
