<?php

namespace App;

use App\Models\SystemAlert;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Media;
use Mtc\MercuryDataModels\Tenant;
use Mtc\MercuryDataModels\Vehicle;

class SystemAlertRepository
{
    public function getAllAlerts(): array
    {
        return [

        ];
    }

    public function checkAlerts(Tenant $tenant)
    {
        $this->getActiveAlerts($tenant)
            ->filter(fn(SystemAlert $alert) => $this->testAlert($alert))
            ->eac(fn(SystemAlert $alert) => $this->notifyAlert($alert));
    }

    private function getActiveAlerts(Tenant $tenant): Collection
    {
        return SystemAlert::query()
            ->where('tenant_id', $tenant->id)
            ->get();
    }

    private function testAlert(SystemAlert $alert): bool
    {
        return match ($alert->alert_type) {
            'no_stock' => Vehicle::query()->active()->count() === 0,
            'no_new_enquiries' => Enquiry::query()
                    ->where('ingested_at', '>=', Carbon::now()->subHours($alert->time_condition))
                    ->count() === 0,
            'no_new_images' => Media::query()
                ->where('created_at', '>=', Carbon::now()->subHours($alert->time_condition))
                ->where('image_provider', Carbon::now()->subHours($alert->value_condition))
                ->count() === 0,

            default => false
        };
    }

    private function notifyAlert(SystemAlert $alert)
    {

    }
}
