<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CO2FilterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'CO2',
                'config_key' => 'automotive-vehicle-filters-co2',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Insurance Group',
                'config_key' => 'automotive-vehicle-filters-insurance-group',
                'type' => 'boolean',
                'superadmin' => true,
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Filtering',
                'name' => 'Postcode',
                'config_key' => 'automotive-vehicle-filters-postcode',
                'type' => 'boolean',
                'superadmin' => true,
                'value' => false,
            ],
        ];
    }
}
