<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class MinimumDepositSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // make the new settings
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));

        // adjust name and description of existing setting to help differentiate from new deposit setting
        Setting::query()
            ->where('config_key', 'finance-deposit-flat-rate-treshold')
            ->update([
                'name' => 'Vehicle price threshold for deposit amount flat rate',
                'description' => 'Full vehicle price below which the flat rate will be applied instead of deposit percentage',
            ]);
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Minimum default deposit amount',
                'config_key' => 'finance-minimum-deposit-amount',
                'type' => 'int',
                'value' => 0,
                'min_tier' => 'pro',
                'description' => 'The minimum default deposit value allowed.'
                    . ' Calculated deposits below this amount will be adjusted to this amount.',
            ],
        ];
    }
}
