<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\Setting;

class TrackingCodeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Setting::query()
            ->where('section', 'SEO')
            ->update([
                'section' => 'Tracking',
                'group' =>  'Google Analytics',
            ]);

        Setting::query()
            ->where('config_key', 'seo-gtm_id')
            ->delete();

        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'Facebook tracking pixel code',
                'config_key' => 'tracking-facebook-code',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="https://www.facebook.com/gpa/blog/the-facebook-pixel" target="_blank">Facebook tracking pixel.</a>'
                    . ' Please <em>enter the unique code only</em>!',
            ],
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'TikTok tracking pixel code',
                'config_key' => 'tracking-tiktok-code',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="https://ads.tiktok.com/help/article/tiktok-pixel" target="_blank">TikTok</a> ads pixel.'
                    . ' Please <em>enter the unique code only</em>!',
            ],
            [
                'tab' => 'Site',
                'section' => 'Tracking',
                'group' => 'Tracking Pixels',
                'name' => 'HotJar code',
                'config_key' => 'tracking-hotjar-code',
                'type' => 'secret',
                'value' => '',
                'description' => '<a href="https://www.hotjar.com/" target="_blank">HotJar</a> UX heatmap tool integration.'
                    . ' Please <em>enter the unique code only</em>!',
            ],
        ];
    }
}
