<?php

namespace Tests\Feature;

use App\Console\Commands\ClearSalesChannelHistory;
use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Mtc\MercuryDataModels\SalesChannelHistory;
use Tests\TenantTestCase;
use Tests\TestCase;

class ClearSalesChannelHistoryTest extends TenantTestCase
{
    /**
     * A basic feature test example.
     *
     * @return void
     */
    public function testClearOldRecords()
    {
        SalesChannelHistory::factory(10)->create(['created_at' => Carbon::now()->subDays(99)]);
        SalesChannelHistory::factory(15)->create(['created_at' => Carbon::now()->subDays(3)]);

        $this->assertEquals(25, SalesChannelHistory::query()->count());
        $response = $this->artisan(ClearSalesChannelHistory::class);
        $response->run();
        $response->assertExitCode(0);

        $this->assertEquals(15, SalesChannelHistory::query()->count());
    }
}
