<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class FinanceDepositPercentageSettings extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Treat values below 100 as percentages for deposit',
                'config_key' => 'finance-deposit-sub-100-deposit-percentage',
                'type' => 'boolean',
                'value' => false,
                'description' => 'All values under 100 are treated as percentages,'
                    . ' everything else is treated as amount',
                'order' => 11,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Flat rate for deposit amount',
                'config_key' => 'finance-deposit-flat-rate-amount',
                'type' => 'int',
                'value' => null,
                'min_tier' => 'pro',
                'description' => 'When below a certain treshold the given value will be used instead of the '
                    . 'default finance deposit percentage',
                'order' => 12,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'General',
                'name' => 'Threshold for deposit amount flat rate',
                'config_key' => 'finance-deposit-flat-rate-treshold',
                'type' => 'int',
                'value' => null,
                'min_tier' => 'pro',
                'description' => 'Amount below which the flat rate will be applied instead of deposit percentage',
                'order' => 13,
            ],
        ];
    }
}
