<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\IntegrationRepository;
use App\Tier;
use Database\Seeders\Tenant\ChatSettingSeeder;
use Database\Seeders\Tenant\FinanceSettingSeeder;
use Tests\TenantTestCase;

class IntegrationRepositoryTest extends TenantTestCase
{
    public function testKeyIsEnableSettingValue()
    {
        $tests = [
            'sales-channels-motors-co-uk-enabled' => true,
            'sales-channels-motors-co-uk-ftp_username' => false,
            'crm-enquiry-max-enabled' => true,
            'chat-rapid-rtc-enabled' => true,
            'chat-live-chat-enabled' => true,
            'chat-live-chat-client_id' => false,
            'foo-baz-bar' => false,
        ];
        $repository = new IntegrationRepository();
        foreach ($tests as $value => $result) {
            $this->assertEquals($result, $repository->keyIsEnableSettingValue($value));
        }
    }

    public function testGetTypeFromKey()
    {
        $tests = [
            'sales-channels-motors-co-uk-enabled' => 'sales-channels',
            'crm-enquiry-max-enabled' => 'crm',
            'chat-rapid-rtc-enabled' => 'chat',
            'chat-live-chat-enabled' => 'chat',
            'foo-baz-bar' => null,
        ];
        $repository = new IntegrationRepository();
        foreach ($tests as $value => $result) {
            $this->assertEquals($result, $repository->getTypeFromKey($value));
        }
    }

    public function testGetLimitForType()
    {
        $repository = new IntegrationRepository();
        $this->assertEquals(2, $repository->getLimitForType('sales-channels', Tier::LITE->value));
        $this->assertEquals(5, $repository->getLimitForType('sales-channels', Tier::STANDARD->value));
        $this->assertEquals(999, $repository->getLimitForType('sales-channels', Tier::PRO->value));
        $this->assertEquals(1, $repository->getLimitForType('crm', Tier::LITE->value));
        $this->assertEquals(1, $repository->getLimitForType('chat', Tier::LITE->value));
    }

    public function testCheckEnabledCountForType()
    {
        $repository = new IntegrationRepository();
        $input = [
            'chat-rapid-rtc-enabled' => true,
            'chat-rapid-rtc-key' => 'foo',
            'chat-live-chat-enabled' => true,
            'chat-live-chat-client_id' => 'something',
        ];

        $this->assertEquals(2, $repository->checkEnabledCountForType($input, 'chat'));
        $input = [
            'chat-rapid-rtc-enabled' => false,
            'chat-rapid-rtc-key' => 'foo',
            'chat-live-chat-enabled' => true,
            'chat-live-chat-client_id' => 'something',
        ];

        $this->assertEquals(1, $repository->checkEnabledCountForType($input, 'chat'));
    }
}
