<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Mtc\MercuryDataModels\ApiNotification;

class ClearApiNotifications extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'clear:api-notifications';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean out api notifications that are older than 30 days';

    private int $defaultExpiryDays = 30;

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiry = Settings::get('app-log-expiry-days') ?: $this->defaultExpiryDays;
        ApiNotification::query()
            ->where('updated_at', '<=', Carbon::now()->subDays($expiry))
            ->delete();
    }
}
