<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreAttributeRequest;
use App\Http\Requests\UpdateAttributeRequest;
use App\Http\Resources\AttributeList;
use App\Http\Resources\AttributeView;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\VehicleAttribute;

class AttributeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index($model): AttributeList
    {
        return new AttributeList(VehicleAttribute::query()->where('model', $model)->get());
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store($model, StoreAttributeRequest $request): AttributeView
    {
        $attribute = VehicleAttribute::query()
            ->create($request->validated());

        return new AttributeView($attribute);
    }

    /**
     * Display the specified resource.
     */
    public function show($model, VehicleAttribute $attribute): AttributeView
    {
        return new AttributeView($attribute);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAttributeRequest $request, $model, VehicleAttribute $attribute): AttributeView
    {
        $attribute->update($request->input());
        return new AttributeView($attribute);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($model, VehicleAttribute $attribute): Response
    {
        $attribute->delete();
        return response('ok');
    }
}
