<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class SocialMetaDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Social Meta Data',
                'name' => 'OG Title',
                'config_key' => 'seo-meta-data-og-title',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'description' => 'Title shown when the page is shared on Facebook or other Open Graph platforms.'
                    . ' Defaults to meta title.',
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Social Meta Data',
                'name' => 'OG Description',
                'config_key' => 'seo-meta-data-og-description',
                'type' => 'string',
                'value' => '',
                'order' => 2,
                'description' => 'Description used in Open Graph. Defaults to meta description.',
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Social Meta Data',
                'name' => 'OG URL',
                'config_key' => 'seo-meta-data-og-url',
                'type' => 'string',
                'value' => '',
                'order' => 3,
                'description' => 'Canonical URL for the Open Graph share. Defaults to current page URL.',
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Social Meta Data',
                'name' => 'Twitter Title',
                'config_key' => 'seo-meta-data-twitter-title',
                'type' => 'string',
                'value' => '',
                'order' => 4,
                'description' => 'Title shown when the page is shared on Twitter. Defaults to meta title.',
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Social Meta Data',
                'name' => 'Twitter Description',
                'config_key' => 'seo-meta-data-twitter-description',
                'type' => 'string',
                'value' => '',
                'order' => 5,
                'description' => 'Description shown in Twitter cards. Defaults to meta description.',
            ],
        ];
    }
}
