<?php

return [
    'tabs' => [
        'Site' => 'General settings about website - name, logo, global contact details, content, branding information',
        'CRM' => 'CRM configuration - live chats and integrations with CRM systems',
        'Automotive' => 'Stock syncs, spec and feature providers, finance, valuation and other systems',
        'Domains' => 'Configure website domains',
        'Users' => 'User management and access to sections',
        'Replacements' => 'Set up term replacements for ensuring consistent wording across system',
        'Import Maps' => 'Set up how stock files should be processed by the system',
        'Export Maps' =>  'Define export formats',
        'Import Conditions' => 'Create conditions for vehicle import and publish based on specific criteria',
        'Colour Map' => 'Group and manage brand specific colours (e.g. Midnight Blue) under simplified options (blue)',
    ],
    'descriptions' => [
        'general-site' => '<p>Manage site-wide settings.<br/> Top level information like site name/logo, primary contact information, branding colours, access restriction etc.</p>',
        'general-automotive' => '<p>Manage automotive settings.<br/> Defaults for vehicles and dealerships, distance measurement used by system.</p>',
        'mail' => '<p>Email configuration. Outgoing email service and name/email to send as.</p>',
        'social-media' => '<p>Links to social media accounts. Leave empty if non-existent.</p>',
        'seo' => '<p>Global SEO settings - Google Analytics/Tag manager.</p>',
        'live-chat' => '<p>Set up and enable Live Chat widget on website.</p>',
        'integrations' => '<p>Connect with external CRM systems for tracking leads.</p>',
        'newsletter' => '<p>Handle newsletter signups and send them to a specified service.</p>',
        'image-synchronization' => '<p>Automatically sync images to website from one of the supported services.</p>',
        'sales-channels-feeds' => '<p>Export vehicle listings to any other services for promoting them on these services.</p>',
        'dms-vehicle-sync' => '<p>Synchronise used vehicle stock with a Dealer Management System.</p>',
        'finance' => '<p>Provide representative finance examples on vehicles using one of the offered providers.</p>',
        'sales' => '<p>Provide a sales journey for purchasing a vehicle.</p>',
        'filter' => '<p>Configure used vehicle catalog filtering experience.</p>',
        'specification-feature-synchronization' => '<p>Set up automated specification and feature synchronization on used vehicles.</p>',
        'autotrader' => '<p>
            <a href="https://www.autotrader.co.uk" target="_blank">AutoTrader</a> integrations.
            This section allows setting up features using AutoTrader API.<br/>
            To allow use your organisation does require an AutoTrader account and must inform AutoTrader that
            <strong>mtc media</strong> is your commercial partner to allow granting our system access to the organisations
            merchant stock and features.
        </p>',
        'valuation' => '<p>Provide used vehicle valuation for customers as part of trade-in or enquiry.</p>',
        'content' => '<p>Configure content management features</p>',
        'tracking' => '<p>Set up marketing tracking codes - Google Analytics, tracking pixels, UX heatmaps etc.</p>',
        'ai' => '<p>Integrations with AI tools to generate content on the website (e.g. vehicle descriptions)</p>',
    ]
];
