<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\MercuryDataModels\CarConfiguratorPackage;

class ConfiguratorPackageList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->through(fn(CarConfiguratorPackage $model) => [
            'id' => $model->id,
            'title' => $model->name,
        ]);
        return parent::toArray($request);
    }
}
